clear all
clc
close all

%% Create Data

load AALabData
Y=Action;
Row=row;
clear row column

load AANewData
Y=[Y;modal'];
Row=[Row;row'];
clear modal row

load AAMTData
s=length(row);
act=zeros(s,1);
for i=1:s
    act(i)=modal{i}(1); %choose earlier action when multiple modal, should test for robustness
end

Y=[Y;act];
Row=[Row;row];

testalpha=0.01:0.2:2;
r=length(testalpha);

% Find Level 1 Prediction with Risk Aversion

n=length(Y);
K=10;
c = cvpartition(n,'KFold',K);
bestalpha=zeros(1,K);
Accuracy=zeros(1,K);
for k=1:K
    IndTrain=find(c.training(k));
    rowTrain=Row(IndTrain);
    YTrain=Y(IndTrain);
    
    m=length(rowTrain);
    
    % Train risk aversion parameter
    Acc=zeros(1,r);
    for i=1:r
        alpha=testalpha(i);
        lev1R=zeros(1,m);
        acc=zeros(1,m);
        for h=1:m
            R=rowTrain{h}.^alpha;
            [~,lev1R(h)]=max(sum(R,2));
            acc(h)=logical(YTrain(h)==lev1R(h));
        end
        Acc(i)=mean(acc);
        clear lev1R acc
    end
    [~,best]=max(Acc);
    bestalpha(k)=testalpha(best);
    
    IndTest=find(c.test(k));
    rowTest=Row(IndTest);
    YTest=Y(IndTest);
    
    s=length(rowTest);
    pred=zeros(1,s);
    for i=1:s
        alpha=bestalpha(k);
        R=rowTest{i}.^alpha;
        [~,pred(i)]=max(sum(R,2));
        acc(i)=logical(YTest(i)==pred(i));
    end
    Accuracy(k)=sum(acc)/s;
    clear acc
end

'Accuracy'
mean(Accuracy)

'Standard Error'
sqrt(var(Accuracy))/sqrt(K)

'Alpha Estimate'
mean(bestalpha)
